const devices={template:`
<div>
    <button  v-if="Authenticated=='admin'" type="button"
     class="btn btn-primary m-2 fload-end"
     data-bs-toggle="modal"
     data-bs-target="#exampleModal"
     @click="addClick()">
        Add Device
    </button>
    <button v-if="Authenticated=='false'" ref="callquery" type="button"
     class="btn btn-primary m-2 fload-end"
     data-bs-toggle="modal"
     data-bs-target="#loginModal">
        Login
    </button>
    <button ref="callpopup" type="button"
     class="btn d-none"
     data-bs-toggle="modal"
     data-bs-target="#popup">
    </button>
    <table class="table table-responsive table-striped table-sm">
    <!-- TABLE HEAD --------------------------------------------------------------------->
    <thead>
        <tr>
            <th class="text-center">
                <div data-toggle="tooltip" data-placement="top" title="Status of the MOSCA-LCM Service: ready">
                    <svg v-if="ServiceState=='ready'" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#008000" class="bi bi-gear-fill" viewBox="0 0 16 16">
                        <path d="M9.405 1.05c-.413-1.4-2.397-1.4-2.81 0l-.1.34a1.464 1.464 0 0 1-2.105.872l-.31-.17c-1.283-.698-2.686.705-1.987 1.987l.169.311c.446.82.023 1.841-.872 2.105l-.34.1c-1.4.413-1.4 2.397 0 2.81l.34.1a1.464 1.464 0 0 1 .872 2.105l-.17.31c-.698 1.283.705 2.686 1.987 1.987l.311-.169a1.464 1.464 0 0 1 2.105.872l.1.34c.413 1.4 2.397 1.4 2.81 0l.1-.34a1.464 1.464 0 0 1 2.105-.872l.31.17c1.283.698 2.686-.705 1.987-1.987l-.169-.311a1.464 1.464 0 0 1 .872-2.105l.34-.1c1.4-.413 1.4-2.397 0-2.81l-.34-.1a1.464 1.464 0 0 1-.872-2.105l.17-.31c.698-1.283-.705-2.686-1.987-1.987l-.311.169a1.464 1.464 0 0 1-2.105-.872zM8 10.93a2.929 2.929 0 1 1 0-5.86 2.929 2.929 0 0 1 0 5.858z"/>
                    </svg>
                </div>
                <div data-toggle="tooltip" data-placement="top" title="Status of the MOSCA-LCM Service: running">
                    <svg v-if="ServiceState=='running'" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#80FF80" class="bi bi-gear-fill" viewBox="0 0 16 16">
                        <path d="M9.405 1.05c-.413-1.4-2.397-1.4-2.81 0l-.1.34a1.464 1.464 0 0 1-2.105.872l-.31-.17c-1.283-.698-2.686.705-1.987 1.987l.169.311c.446.82.023 1.841-.872 2.105l-.34.1c-1.4.413-1.4 2.397 0 2.81l.34.1a1.464 1.464 0 0 1 .872 2.105l-.17.31c-.698 1.283.705 2.686 1.987 1.987l.311-.169a1.464 1.464 0 0 1 2.105.872l.1.34c.413 1.4 2.397 1.4 2.81 0l.1-.34a1.464 1.464 0 0 1 2.105-.872l.31.17c1.283.698 2.686-.705 1.987-1.987l-.169-.311a1.464 1.464 0 0 1 .872-2.105l.34-.1c1.4-.413 1.4-2.397 0-2.81l-.34-.1a1.464 1.464 0 0 1-.872-2.105l.17-.31c.698-1.283-.705-2.686-1.987-1.987l-.311.169a1.464 1.464 0 0 1-2.105-.872zM8 10.93a2.929 2.929 0 1 1 0-5.86 2.929 2.929 0 0 1 0 5.858z"/>
                    </svg>
                </div>
                <div data-toggle="tooltip" data-placement="top" title="Status of the MOSCA-LCM Service: disabled">
                    <svg v-if="ServiceState=='disabled'" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#FF0000" class="bi bi-gear-fill" viewBox="0 0 16 16">
                        <path d="M9.405 1.05c-.413-1.4-2.397-1.4-2.81 0l-.1.34a1.464 1.464 0 0 1-2.105.872l-.31-.17c-1.283-.698-2.686.705-1.987 1.987l.169.311c.446.82.023 1.841-.872 2.105l-.34.1c-1.4.413-1.4 2.397 0 2.81l.34.1a1.464 1.464 0 0 1 .872 2.105l-.17.31c-.698 1.283.705 2.686 1.987 1.987l.311-.169a1.464 1.464 0 0 1 2.105.872l.1.34c.413 1.4 2.397 1.4 2.81 0l.1-.34a1.464 1.464 0 0 1 2.105-.872l.31.17c1.283.698 2.686-.705 1.987-1.987l-.169-.311a1.464 1.464 0 0 1 .872-2.105l.34-.1c1.4-.413 1.4-2.397 0-2.81l-.34-.1a1.464 1.464 0 0 1-.872-2.105l.17-.31c.698-1.283-.705-2.686-1.987-1.987l-.311.169a1.464 1.464 0 0 1-2.105-.872zM8 10.93a2.929 2.929 0 1 1 0-5.86 2.929 2.929 0 0 1 0 5.858z"/>
                    </svg>
                </div>
                <div data-toggle="tooltip" data-placement="top" title="Status of the MOSCA-LCM Service: unknown">
                    <svg v-if="ServiceState=='unknown'" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#202020" class="bi bi-gear-fill" viewBox="0 0 16 16">
                        <path d="M9.405 1.05c-.413-1.4-2.397-1.4-2.81 0l-.1.34a1.464 1.464 0 0 1-2.105.872l-.31-.17c-1.283-.698-2.686.705-1.987 1.987l.169.311c.446.82.023 1.841-.872 2.105l-.34.1c-1.4.413-1.4 2.397 0 2.81l.34.1a1.464 1.464 0 0 1 .872 2.105l-.17.31c-.698 1.283.705 2.686 1.987 1.987l.311-.169a1.464 1.464 0 0 1 2.105.872l.1.34c.413 1.4 2.397 1.4 2.81 0l.1-.34a1.464 1.464 0 0 1 2.105-.872l.31.17c1.283.698 2.686-.705 1.987-1.987l-.169-.311a1.464 1.464 0 0 1 .872-2.105l.34-.1c1.4-.413 1.4-2.397 0-2.81l-.34-.1a1.464 1.464 0 0 1-.872-2.105l.17-.31c.698-1.283-.705-2.686-1.987-1.987l-.311.169a1.464 1.464 0 0 1-2.105-.872zM8 10.93a2.929 2.929 0 1 1 0-5.86 2.929 2.929 0 0 1 0 5.858z"/>
                    </svg>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="5" height="5" fill="#FFFFFF" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                Status
            </th>
            <th>
                <div class="d-flex flex-row">
                    <input class="form-control m-2"
                        v-model="HostNameFilter"
                        v-on:keyup="FilterFn()"
                        placeholder="Filter">
                    
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('HostName',true)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                        <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                    </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                        @click="sortResult('HostName',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                IP/HostName
            </th>
            <th>
                <div class="d-flex flex-row">
                    <input class="form-control m-2"
                        v-model="CommonNameFilter"
                        v-on:keyup="FilterFn()"
                        placeholder="Filter">

                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CommonName',true)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                        <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                    </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                        @click="sortResult('CommonName',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                CommonName
            </th>
            <th>
                <div class="d-flex flex-row">
                    <input class="form-control m-2"
                        v-model="SerialNumberFilter"
                        v-on:keyup="FilterFn()"
                        placeholder="Filter">

                    <button type="button" class="btn btn-sm"
                    @click="sortResult('SerialNumber',true)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                        <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                    </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                        @click="sortResult('SerialNumber',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                SerialNumber
            </th>
            <th>
                <div class="d-flex flex-row">
                    <input class="form-control m-2"
                        v-model="DeviceTypeFilter"
                        v-on:keyup="FilterFn()"
                        placeholder="Filter">

                    <button type="button" class="btn btn-sm"
                    @click="sortResult('DeviceType',true)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                        <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                    </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                        @click="sortResult('DeviceType',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                DeviceType
            </th>
            <th>
                Certs
            </th>
            <th>
                <div class="d-flex flex-row">
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CertDateTLS',true)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                        </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CertDateTLS',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                TLSCertDate
            </th>
            <th>
                <div class="d-flex flex-row">
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CertDate802',true)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                        </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CertDate802',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                802CertDate
            </th>
            <th>
                <div class="d-flex flex-row">
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('LastContact',true)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                        </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('LastContact',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                LastContact/Delivery
            </th>
            <th>
                <div class="d-flex flex-row">
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CommandFile',true)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                        </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CommandFile',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                CommandFile
            </th>
            <th>
                Auto
            </th>
            <th>
                <div class="d-flex flex-row">
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('ActualCommand',true)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                        </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('ActualCommand',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                ActualCommand
            </th>
            <th>
                <div class="d-flex flex-row">
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CommandStatus',true)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-down-square-fill" viewBox="0 0 16 16">
                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5a.5.5 0 0 1 1 0z"/>
                        </svg>
                    </button>
                    <button type="button" class="btn btn-sm"
                    @click="sortResult('CommandStatus',false)">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#b0b0b0" class="bi bi-arrow-up-square-fill" viewBox="0 0 16 16">
                            <path d="M2 16a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2zm6.5-4.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 1 0z"/>
                        </svg>
                    </button>
                </div>
                CommandStatus
            </th>
            <th>
                <div v-if="Authenticated=='admin'">
                    Options
                </div>
            </th>
        </tr>
    </thead>
    <tbody>
        <!-- TABLE BODY --------------------------------------------------------------------->
        <tr v-for="dev in devices">
            <td class="text-center align-middle">
                <svg v-if="dev.Status==1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#00a000" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else-if="dev.Status==2" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#80FF00" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else-if="dev.Status==3" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#FFFF00" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else-if="dev.Status==4" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#a0a0a0" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else-if="dev.Status==5" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#0000FF" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else-if="dev.Status==6" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#FF0000" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else-if="dev.Status==7" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#a000FF" class="bi bi-circle-fill" viewBox="0 0 16 16">
                    <circle cx="8" cy="8" r="8"/>
                </svg>
                <svg v-else="dev.Status==0" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                </svg>
                <!--{{dev.Status}}-->
            </td> 
            <td class="align-middle">{{dev.HostName}}</td>
            <td class="align-middle">{{dev.CommonName}}</td>
            <td class="align-middle">{{dev.SerialNumber}}</td>
            <td class="align-middle">{{dev.DeviceType}}</td>
            <td>
                <!--Cert Details -->
                <button type="button" class="btn btn-light mr-1"
                 data-bs-toggle="modal"
                 data-bs-target="#detailsModal"
                 @click="detailsClick(dev)"
                 data-toggle="tooltip" data-placement="top" title="Get Certificate Details">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-ticket-detailed" viewBox="0 0 16 16">
                        <path d="M4 5.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm0 5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5ZM5 7a1 1 0 0 0 0 2h6a1 1 0 1 0 0-2H5Z"/>
                        <path d="M0 4.5A1.5 1.5 0 0 1 1.5 3h13A1.5 1.5 0 0 1 16 4.5V6a.5.5 0 0 1-.5.5 1.5 1.5 0 0 0 0 3 .5.5 0 0 1 .5.5v1.5a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 11.5V10a.5.5 0 0 1 .5-.5 1.5 1.5 0 1 0 0-3A.5.5 0 0 1 0 6V4.5ZM1.5 4a.5.5 0 0 0-.5.5v1.05a2.5 2.5 0 0 1 0 4.9v1.05a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-1.05a2.5 2.5 0 0 1 0-4.9V4.5a.5.5 0 0 0-.5-.5h-13Z"/>
                    </svg>
                </button>
            </td>
            <td class="align-middle">{{dev.CertDateTLS}}</td>
            <td class="align-middle">{{dev.CertDate802}}</td>
            <td class="align-middle text-nowrap">
                {{ formatLastContact(dev.LastContact) }}
            </td>
            <td class="align-middle text-nowrap">{{dev.CommandFile}}</td>
            <td class="align-middle">
                <svg v-if="dev.Auto==true" xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-check" viewBox="0 0 16 16">
                    <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z"/>
                </svg>
            </td>
            <td class="align-middle text-nowrap">{{dev.ActualCommand}}</td>
            <td class="align-middle text-nowrap">{{dev.CommandStatus}}</td>
            <td class=text-nowrap>
                <button v-if="Authenticated=='admin'" type="button" @click="yesterdayClick(dev.DeviceID)"
                 class="btn btn-light mr-1" data-toggle="tooltip" data-placement="top" title="Set last readout to yesterday">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-skip-backward-fill" viewBox="0 0 16 16">
                        <path d="M.5 3.5A.5.5 0 0 0 0 4v8a.5.5 0 0 0 1 0V8.753l6.267 3.636c.54.313 1.233-.066 1.233-.697v-2.94l6.267 3.636c.54.314 1.233-.065 1.233-.696V4.308c0-.63-.693-1.01-1.233-.696L8.5 7.248v-2.94c0-.63-.692-1.01-1.233-.696L1 7.248V4a.5.5 0 0 0-.5-.5z"/>
                    </svg>
                </button>
                <button v-if="Authenticated=='admin'" type="button" @click="resetClick(dev.DeviceID)"
                 class="btn btn-light mr-1" data-toggle="tooltip" data-placement="top" title="Reset error counter">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bootstrap-reboot" viewBox="0 0 16 16">
                        <path d="M1.161 8a6.84 6.84 0 1 0 6.842-6.84.58.58 0 1 1 0-1.16 8 8 0 1 1-6.556 3.412l-.663-.577a.58.58 0 0 1 .227-.997l2.52-.69a.58.58 0 0 1 .728.633l-.332 2.592a.58.58 0 0 1-.956.364l-.643-.56A6.812 6.812 0 0 0 1.16 8z"/>
                        <path d="M6.641 11.671V8.843h1.57l1.498 2.828h1.314L9.377 8.665c.897-.3 1.427-1.106 1.427-2.1 0-1.37-.943-2.246-2.456-2.246H5.5v7.352h1.141zm0-3.75V5.277h1.57c.881 0 1.416.499 1.416 1.32 0 .84-.504 1.324-1.386 1.324h-1.6z"/>
                    </svg>
                </button>
                <button v-if="Authenticated=='admin'" type="button"
                 class="btn btn-light mr-1"
                 data-bs-toggle="modal"
                 data-bs-target="#exampleModal" @click="editClick(dev)"
                 data-toggle="tooltip" data-placement="top" title="Edit Device">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                    <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                    <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                    </svg>
                </button>
                <button v-if="Authenticated=='admin'" type="button" @click="deleteClick(dev.DeviceID)"
                 class="btn btn-light mr-1" data-toggle="tooltip" data-placement="top" title="Delete Device">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash-fill" viewBox="0 0 16 16">
                    <path d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 1 0z"/>
                    </svg>
                </button>
                <!--https://icons.getbootstrap.com -->
                <button v-if="Authenticated=='admin'" type="button" @click="StartServiceClick(dev.DeviceID)"
                 class="btn btn-light mr-1" data-toggle="tooltip" data-placement="top" title="Start service for this device">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-play-circle" viewBox="0 0 16 16">
                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                        <path d="M6.271 5.055a.5.5 0 0 1 .52.038l3.5 2.5a.5.5 0 0 1 0 .814l-3.5 2.5A.5.5 0 0 1 6 10.5v-5a.5.5 0 0 1 .271-.445"/>
                    </svg>
                </button>
            </td>
        </tr>
    </tbody>
    </table>
    <!-- MODAL CREATE & EDIT --------------------------------------------------------------------->
    <div class="modal fade" id="exampleModal" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{modalTitle}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="input-group mb-3">
                        <div class="input-group-prepend col-3">
                            <span class="input-group-text col-11">IP/Hostname</span>
                        </div>
                        <input type="text" class="form-control" v-model="HostName">
                    </div>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend col-3">
                            <span class="input-group-text col-11">CommonName</span>
                        </div>
                        <input type="text" class="form-control" v-model="CommonName">
                    </div>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend col-3">
                            <span class="input-group-text col-11">SerialNumber</span>
                        </div>
                        <input type="text" class="form-control" v-model="SerialNumber">
                    </div>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend col-3">
                            <span class="input-group-text col-11">CommandFile</span>
                        </div>
                        <select class="form-select" v-model="CommandFile">
                            <option v-for="files in commandfiles">
                                {{files}}
                            </option>
                        </select>
                        <!--
                        <div class="input-group-prepend col-3">
                            <span class="input-group-text col-11">CommandFile</span>
                        </div>
                        <input type="text" class="form-control" v-model="CommandFile">
                        -->
                    </div>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend col-3">
                            <span class="input-group-text col-11">Auto</span>
                        </div>
                        <div class="form-check">
                            <input :disabled="(CommandFile=='')" class="form-check-input" type="checkbox" v-model="Auto" id="flexCheckIndeterminate">
                            <label class="form-check-label" for="flexCheckIndeterminate"></label>
                        </div>
                    </div>
                <!-- uncomment this if you want to have a seperated footer
                </div>
                <div class="modal-footer">
                -->
                    <button :disabled="(HostName=='' || CommonName=='')" type="button" @click="createClick()" v-if="DeviceID==0" 
                    class="btn btn-primary" data-bs-dismiss="modal">
                        Create
                    </button>
                    <button :disabled="(HostName=='' || CommonName=='')" type="button" @click="updateClick()" v-if="DeviceID!=0" 
                    class="btn btn-primary" data-bs-dismiss="modal">
                        Update
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODAL DETAILS --------------------------------------------------------------------->
    <div class="modal fade" id="detailsModal" tabindex="-1"
        aria-labelledby="detailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="detailsModalLabel">{{modalTitle}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="input-group mb-3">
                        <span class="input-group-text">CommonName</span>
                        <input type="text" class="form-control" v-model="CommonName">
                        &nbsp
                        <span class="input-group-text">TLS End Date</span>
                        <input type="text" class="form-control" v-model="CertDateTLS">
                        &nbsp    
                        <span class="input-group-text">802.1X End Date</span>
                        <input type="text" class="form-control" v-model="CertDate802">
                    </div>
                    <div class="input-group">
                        <div class="input-group">
                            <div class="input-group-prepend col-3">
                                <span class="input-group-text col-10">TLS Certificate</span>
                            </div>
                            <textarea class="form-control" aria-label="With textarea" v-model="CertNameTLS"></textarea>
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend col-3">
                                <span class="input-group-text col-10">802.1X Certificate</span>
                            </div>
                            <textarea class="form-control" aria-label="With textarea" v-model="CertName802"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- MODAL POPUP --------------------------------------------------------------------->
    <div class="modal fade" id="popup" tabindex="-1" 
        aria-labelledby="detailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="detailsModalLabel">Server feedback</h5>
                    <button ref="closepopup" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <textarea class="form-control" aria-label="With textarea" v-model="PopupText"></textarea>
            </div>
        </div>
    </div>
    <!-- MODAL Query --------------------------------------------------------------------->
    <div class="modal fade" id="loginModal" tabindex="-1" 
        aria-labelledby="queryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="queryModalLabel">Authorization</h5>
                </div>
                
                <div class="input-group mb-3">
                    <span class="input-group-text">Username</span>
                    <input type="text" class="form-control" v-model="Username">
                </div>
                <div class="input-group mb-3">
                    <span class="input-group-text">&nbspPassword</span>
                    <input type="password" class="form-control" v-model="Password">
                </div>
                
                <button type="button" @click="Authenticate(false)" 
                    class="btn btn-primary" data-bs-dismiss="modal">
                        OK
                </button>
            </div>
        </div>
    </div>
</div>
`,

data(){
    return{
        devices:[],
        devicesWithoutFilter:[],
        devicesUnsorted:[],
        commandfiles:[],
        modalTitle:"",
        HostName:"",
        CommonName:"",
        DeviceID:0,
        Status:0,
        Auto:false,
        CommandFile:"",
        SerialNumber:"",
        DeviceType:"",
        HostNameFilter:"",
        CommonNameFilter:"",
        SerialNumberFilter:"",
        DeviceTypeFilter:"",
        CertNameTLS:"",
        CertName802:"",
        CertDateTLS:"",
        CertDate802:"",
        PopupText:"",
        sortProp:"",
        Username:"",
        Password:"",
        Authenticated:"false",
        ServiceState:"unknown",
        sortAsc:false
    } 
},
methods:{
    refreshData(){
        if (this.Authenticated=="admin" || this.Authenticated=="user")
        {
            const token = sessionStorage.getItem("token");
            if (!token) {
                alert("Not authenticated.");
                return;
            }
            axios.get(window.location.origin+"/api/devices",{headers: { Authorization: `Bearer ${token}`}})
            .then((response)=>{
                //this.devices=response.data;
                this.devicesWithoutFilter=response.data;
                this.Delivery=true;
            });
            setTimeout(this.FilterFn,200);
            axios.get(window.location.origin+"/api/commandfiles", {headers: { Authorization: `Bearer ${token}`}})
            .then((response)=>{
                //alert(response.data);
                var restext=response.data;
                this.commandfiles=restext.split(",");
            });
            axios.put(window.location.origin+"/api/Service",{Command:"getstate"},{headers: { Authorization: `Bearer ${token}`}})
            .then((response)=>{
                this.ServiceState=response.data;
                //alert(response.data);
            });
        }
    },
    formatLastContact(dateStr) {
    if (!dateStr) return '';
    const date = new Date(dateStr);
    const now = new Date();
    // format date (z. B. 2025-05-19)
    const dateOnly = date.toISOString().split('T')[0];
    if (date > now) {
      return 'D ' + dateOnly;
    }
    // not future->show original
    return dateStr;
    },
    Authenticate(silent){
        axios.post(window.location.origin+"/api/auth/login",{
            Username:this.Username,
            Password:this.Password
        })
        .then((response)=>{
            //alert(response.data.accessToken);
            if (response.data.accessToken) {
                sessionStorage.setItem("token", response.data.accessToken);
                axios.defaults.headers.common["Authorization"] = `Bearer ${response.data.accessToken}`;
                this.Authenticated=this.getUserRole();
                //alert(this.Authenticated);
                this.refreshData();
                this.Password="";
            }
        })
        .catch((error) => {
            this.Password="";
            if (error.response) {
                if (error.response.status === 401) {
                    
                    if (silent==false){
                        alert("Unauthorized: Wrong username or password.");
                    }
                } else {
                    alert(`Error: ${error.response.status} - ${error.response.statusText}`);
                }
            } else if (error.request) {
                alert("No answer from server.");
            } else {
                alert("Error sending query: " + error.message);
            }
        });
    },
    getUserRole() {
        const token = sessionStorage.getItem("token"); //Get Token from sessionStorage
        if (!token) return null;
        const payload = JSON.parse(atob(token.split(".")[1])); // decode JWT
        return payload["role"] || payload["http://schemas.microsoft.com/ws/2008/06/identity/claims/role"] || null; //Benutzerrolle auslesen
    },
    addClick(){
        this.DeviceID=0,
        this.modalTitle="Add Device";
        this.HostName="";
        this.CommonName="";
        this.SerialNumber="";
        this.CommandFile="";
        this.Auto=false;

        //alert(window.location.origin);
    },
    editClick(dev){
        this.modalTitle="Edit Device";
        this.DeviceID=dev.DeviceID;
        this.HostName=dev.HostName;
        this.CommonName=dev.CommonName;
        this.SerialNumber=dev.SerialNumber;
        this.CommandFile=dev.CommandFile;
        this.Auto=dev.Auto;
    },
    detailsClick(dev){
        this.modalTitle="Certificate Details";
        this.HostName=dev.HostName;
        this.CommonName=dev.CommonName;
        this.CertDateTLS=dev.CertDateTLS;
        this.CertNameTLS=dev.CertNameTLS;
        this.CertDate802=dev.CertDate802;
        this.CertName802=dev.CertName802;
    },
    createClick(){
        const token = sessionStorage.getItem("token"); // Token aus sessionStorage holen
        if (!token) {
            alert("Not authenticated.");
            return;
        }
        axios.post(window.location.origin+"/api/devices",{
            HostName:this.HostName,
            CommonName:this.CommonName,
            SerialNumber:this.SerialNumber,
            CommandFile:this.CommandFile,
            Auto:this.Auto
        },{headers: { Authorization: `Bearer ${token}`}})
        .then((response)=>{
            this.refreshData();
            this.PopupText=response.data;
            this.$refs.callpopup.click();
            setTimeout(
                this.ClosePopup, 2000
            );
        });
    },
    ClosePopup(){
        this.$refs.closepopup.click();
    },
    updateClick(){
        const token = sessionStorage.getItem("token"); // Token aus sessionStorage holen
        if (!token) {
            alert("Not authenticated.");
            return;
        }
        axios.put(window.location.origin+"/api/devices",{
            DeviceID:this.DeviceID,
            HostName:this.HostName,
            CommonName:this.CommonName,
            SerialNumber:this.SerialNumber,
            CommandFile:this.CommandFile,
            Auto:this.Auto,
            SetYesterday:false
        },{headers: { Authorization: `Bearer ${token}`}})
        .then((response)=>{
            this.refreshData();
            //alert(response.data);
            this.PopupText=response.data;
            this.$refs.callpopup.click();
            setTimeout(
                this.ClosePopup, 2000
            );
        });
    },
    yesterdayClick(id){
        if(!confirm("The device will be processed again. Are you sure?")){
            return;
        }
        const token = sessionStorage.getItem("token"); // Token aus sessionStorage holen
        if (!token) {
            alert("Not authenticated.");
            return;
        }
        axios.put(window.location.origin+"/api/devices",{
            DeviceID:id,
            SetYesterday:true
        },{headers: { Authorization: `Bearer ${token}`}})
        .then((response)=>{
            this.refreshData();
            this.PopupText=response.data;
            this.$refs.callpopup.click();
            setTimeout(
                this.ClosePopup, 2000
            );
        });
    },
    resetClick(id){
        if(!confirm("The error counter for this device will be reset. Are you sure?")){
            return;
        }
        const token = sessionStorage.getItem("token");
        if (!token) {
            alert("Not authenticated.");
            return;
        }
        axios.put(window.location.origin+"/api/devices",{
            DeviceID:id,
            ResetCommand:true
        },{headers: { Authorization: `Bearer ${token}`}})
        .then((response)=>{
            this.refreshData();
            this.PopupText=response.data;
            this.$refs.callpopup.click();
            setTimeout(
                this.ClosePopup, 2000
            );
        });
    },
    StartServiceClick(id){
        if(!confirm("The MOSCA-LCM service will be started for this device. Are you sure?")){
            return;
        }
        const token = sessionStorage.getItem("token");
        if (!token) {
            alert("Not authenticated.");
            return;
        }
        axios.put(window.location.origin+"/api/devices",{
            DeviceID:id,
            StartService:true
        },{headers: { Authorization: `Bearer ${token}`}})
        .then((response)=>{
            this.refreshData();
            this.PopupText=response.data;
            this.$refs.callpopup.click();
            setTimeout(
                this.ClosePopup, 5000
            );
        });
    },
    deleteClick(id){
        if(!confirm("The device will be deleted from the list. Are you sure?")){
            return;
        }
        const token = sessionStorage.getItem("token");
        if (!token) {
            alert("Not authenticated.");
            return;
        }
        axios.delete(window.location.origin+"/api/devices/"+id,{headers: { Authorization: `Bearer ${token}`}})
        .then((response)=>{
            this.refreshData();
            this.PopupText=response.data;
            this.$refs.callpopup.click();
            setTimeout(
                this.ClosePopup, 2000
            );
        });
    },
    FilterFn(){
        //alert(this.HostNameFilter);
        var CommonNameFilter=this.CommonNameFilter;
        var HostNameFilter=this.HostNameFilter;
        var SerialNumberFilter=this.SerialNumberFilter;
        var DeviceTypeFilter=this.DeviceTypeFilter;
        var sortAsc=this.sortAsc;
        var sortProp=this.sortProp;

        this.devicesUnsorted=this.devicesWithoutFilter.filter(
            function(el){
                return el.CommonName.toString().toLowerCase().includes(
                    CommonNameFilter.toString().trim().toLowerCase()
                )&&
                el.HostName.toString().toLowerCase().includes(
                    HostNameFilter.toString().trim().toLowerCase()
                )&&
                el.SerialNumber.toString().toLowerCase().includes(
                    SerialNumberFilter.toString().trim().toLowerCase()
                )&&
                el.DeviceType.toString().toLowerCase().includes(
                    DeviceTypeFilter.toString().trim().toLowerCase()
                )
            }
        );
        this.devices=this.devicesUnsorted.sort(function(a,b){

            if(sortAsc){
                return (a[sortProp]>b[sortProp])?1:((a[sortProp]<b[sortProp])?-1:0);
            }
            else{
                return (b[sortProp]>a[sortProp])?1:((b[sortProp]<a[sortProp])?-1:0);
            }
        })
    },
    sortResult(prop,asc){
        this.sortProp=prop;
        this.sortAsc=asc;
        setTimeout(this.FilterFn,100);
    }
},
mounted:function(){
    this.$refs.callquery.click();
    this.refreshInterval = setInterval(() => {
        this.refreshData();
    }, 5000);
}

}